unit korform;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Spin, ColorGrd, Printers, Gordul;

type
  TForm1 = class(TForm)
    ButtonPanel: TPanel;
    RajzolGomb: TButton;
    NyomtatasGomb: TButton;
    TorlesGomb: TButton;
    NyomtatoValasztoGomb: TButton;
    KilepesGomb: TButton;
    SpinA: TSpinEdit;
    SpinB: TSpinEdit;
    SpinD: TSpinEdit;
    SpinALabel: TLabel;
    SpinBLabel: TLabel;
    SpinDLabel: TLabel;
    ColorGrid1: TColorGrid;
    PrinterSetupDialog1: TPrinterSetupDialog;
    procedure KilepesGombClick(Sender: TObject);
    procedure RajzolGombClick(Sender: TObject);
    procedure TorlesGombClick(Sender: TObject);
    procedure NyomtatasGombClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure NyomtatoValasztoGombClick(Sender: TObject);
    procedure FormResize(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}
var
  Torolt:Boolean;

procedure TForm1.KilepesGombClick(Sender: TObject);
begin
 Close;
end;

procedure TForm1.RajzolGombClick(Sender: TObject);
var
 cx, cy : Integer;
begin
 Torolt := False;
 cy := ClientHeight div 2;
 cx := (ClientWidth + ButtonPanel.Width) div 2;
 Canvas.Pixels[cx, cy] := ClBlack;
 Gordit(Canvas, SpinA.Value, SpinB.Value, SpinD.Value,
        cx, cy, ColorGrid1.ForegroundColor);
end;


procedure TForm1.TorlesGombClick(Sender: TObject);
begin
  Torolt:=True;
  Refresh;
end;

{ Az bra nyomtatst vgz eljrs }
procedure TForm1.NyomtatasGombClick(Sender: TObject);
   var
     cx, cy : Integer;
     SkalaTenyezo : Integer;
     Felirat : string;
   begin
    with Printer do
      begin
        SkalaTenyezo := PageWidth div ClientHeight;
        cx := PageWidth div 2;
        cy := PageHeight div 2;
        BeginDoc;
        Gordit(Printer.Canvas,
               SpinA.Value*SkalaTenyezo,
               SpinB.Value*SkalaTenyezo,
               SpinD.Value*SkalaTenyezo,
               cx, cy, clBlack);
        Felirat :='A='+IntToStr(SpinA.Value)+
                  '   B='+IntToStr(SpinB.Value)+
                  '   D='+IntToStr(SpinD.Value);
        cy := Trunc(PageHeight - (PageHeight * 0.07));
        cx := (PageWidth - Canvas.TextWidth(Felirat)) div 2;
        Canvas.TextOut(cx, cy, Felirat);
        EndDoc;
      end;
 end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Torolt := true;
  SpinA.Value := 166;
  SpinB.Value := 68;
  SpinD.Value := 65;
end;

procedure TForm1.FormPaint(Sender: TObject);
var
  cx, cy : Integer;
begin
   if not Torolt then
   begin
     cy := ClientHeight div 2;
     cx := (ClientWidth div 2) + (ButtonPanel.Width div 2);
     Canvas.Pixels[cx, cy] := clBlack;
     Gordit(Canvas, SpinA.Value, SpinB.Value, SpinD.Value,
                 cx, cy, ColorGrid1.ForegroundColor);
   end;
end;

procedure TForm1.NyomtatoValasztoGombClick(Sender: TObject);
begin
  PrinterSetupDialog1.Execute;
end;

procedure TForm1.FormResize(Sender: TObject);
begin
  Invalidate;
end;

end.

